// NetReceiverDlg.cpp : implementation file
//

#include "stdafx.h"
#include "NetReceiver.h"
#include "NetReceiverDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern CNetReceiverApp theApp;

VOID SC_DEBUG( TCHAR * fmt, ... )
{
	TCHAR pszDebugDumpMessage[ 256 ] = "[QC] ";

	va_list marker;

	va_start( marker, fmt );

	vsprintf( pszDebugDumpMessage + 5, fmt, marker );

	va_end( marker );

	strcat( pszDebugDumpMessage, "\n" );

	OutputDebugString( pszDebugDumpMessage );
}

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CNetReceiverDlg dialog

CNetReceiverDlg::CNetReceiverDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CNetReceiverDlg::IDD, pParent)
	, m_staticProfileProperty_quality_max(_T(""))
	, m_staticProfileProperty_bitrate_max(_T(""))
	, m_staticProfileProperty_gop_max(_T(""))
	, m_nPortArray(0)
	, m_nTotalDevice(0)
	, m_staticProfileProperty_RecordMode_max(_T(""))
	, m_staticProfileProperty_FrameRate_max(_T(""))

{
	//{{AFX_DATA_INIT(CNetReceiverDlg)

	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

// COMMUNICATION EMULATOR SCAN DONE CALLBACK
//
QRETURN on_emulator_scan_done_callback( PVOID pEmulator /*IN*/, ULONG nTotalServers /*IN*/, PVOID pUserData /*IN*/ )
{
	CNetReceiverDlg * pNetReceiverDlg = (CNetReceiverDlg *)(pUserData);

	pNetReceiverDlg->m_nTotalDevice = nTotalServers;

	CString cstrNetworkIP;

	if ( pNetReceiverDlg->m_pEmulator ) {
				
			for( int i = 0; i < nTotalServers; i++ )
			{	
			//CString   m_strEmulatorInfo;

			QCAP_GET_COMMUNICATION_EMULATOR_SERVER_INFO( pNetReceiverDlg->m_pEmulator, i, &pNetReceiverDlg->m_cNetworkIP, &pNetReceiverDlg->m_nPortArray[i], &pNetReceiverDlg->ppszNetworkURL );

			cstrNetworkIP = pNetReceiverDlg->ppszNetworkURL;

			pNetReceiverDlg->m_ListEmulator.AddString( cstrNetworkIP );
		}
	}
	return QCAP_RT_OK;
}


// COMMUNICATION CLIENT CONNECTED CALLBACK
//
QRETURN on_communication_client_connected_callback( PVOID pClient /*IN*/, ULONG nTotalVideoSources /*IN*/, ULONG nTotalAudioSources /*IN*/, ULONG nTotalVideoEncoders /*IN*/, ULONG nTotalAudioEncoders /*IN*/, ULONG nTotalProfiles /*IN*/, CHAR * pszManufacturer /*IN*/, CHAR * pszModel /*IN*/, CHAR * pszFirmwareVersion /*IN*/, CHAR * pszSerialNumber /*IN*/, CHAR * pszHardwareID /*IN*/, PVOID pUserData /*IN*/ )
{
	CNetReceiverDlg * pNetReceiverDlg = (CNetReceiverDlg *)(pUserData);

	SC_DEBUG("-------------on_communication_client_connected_callback");

	if ( pNetReceiverDlg->m_pEmulator ) {

		int count1 =  pNetReceiverDlg->m_ListManufacturer.GetCount();

		for ( int i = 0; i < count1; i++ ) {
		
			pNetReceiverDlg->m_ListManufacturer.DeleteString( 0 );

			pNetReceiverDlg->m_ListModel.DeleteString( 0 );

			pNetReceiverDlg->m_ListFirmareVersion.DeleteString( 0 );

			pNetReceiverDlg->m_ListServialNumer.DeleteString( 0 );

			pNetReceiverDlg->m_ListHardwareID.DeleteString( 0 );

			pNetReceiverDlg->m_ListVideoSources.DeleteString( 0 );

			pNetReceiverDlg->m_ListAudioSources.DeleteString( 0 );

			pNetReceiverDlg->m_ListVideoEncoders.DeleteString( 0 );

			pNetReceiverDlg->m_ListAudioEncoders.DeleteString( 0 );
		}

		int count2 =  pNetReceiverDlg->m_ListProfiles.GetCount();

		for ( int i = 0; i < count2; i++ ) {
		
			pNetReceiverDlg->m_ListProfiles.DeleteString( 0 );
		}

		//

		CString		strProfile;

		for( int i = 0; i < nTotalProfiles; i++ )
		{
			strProfile.Format(_T("Profile_%d"), i);

			pNetReceiverDlg->m_ListProfiles.AddString(strProfile);
		}
	
		CString		strManufacturer, strModel, strFirmareVersion, strSerialNumber, strHardwareID, strVideoSources, strAudioSources, strVideoEncoders, strAudioEncoders;

		strManufacturer.Format( _T("Manufacturer: %s"),  pszManufacturer );

		pNetReceiverDlg->m_ListManufacturer.AddString(strManufacturer);

		strModel.Format( _T("Model: %s"),  pszModel );

		pNetReceiverDlg->m_ListModel.AddString(strModel);

		strFirmareVersion.Format( _T("FirmareVersion: %s"),  pszFirmwareVersion );

		pNetReceiverDlg->m_ListFirmareVersion.AddString(strFirmareVersion);

		strSerialNumber.Format( _T("SerialNumber: %s"),  pszSerialNumber );

		pNetReceiverDlg->m_ListServialNumer.AddString(strSerialNumber);

		strHardwareID.Format( _T("HardwareID: %s"),  pszHardwareID );

		pNetReceiverDlg->m_ListHardwareID.AddString(strHardwareID);

		strVideoSources.Format(_T("VideoSources: %d"), nTotalVideoSources);

		pNetReceiverDlg->m_ListVideoSources.AddString(strVideoSources);
	
		strAudioSources.Format(_T("AudioSources: %d"), nTotalAudioSources);

		pNetReceiverDlg->m_ListAudioSources.AddString(strAudioSources);

		strVideoEncoders.Format(_T("VideoEncoders: %d"), nTotalVideoEncoders);

		pNetReceiverDlg->m_ListVideoEncoders.AddString(strVideoEncoders);
	
		strAudioEncoders.Format(_T("AudioEncoders: %d"), nTotalAudioEncoders);

		pNetReceiverDlg->m_ListAudioEncoders.AddString(strAudioEncoders);

		strManufacturer.ReleaseBuffer();
		strModel.ReleaseBuffer();
		strFirmareVersion.ReleaseBuffer();
		strSerialNumber.ReleaseBuffer();
		strHardwareID.ReleaseBuffer();
		strVideoSources.ReleaseBuffer();
		strAudioSources.ReleaseBuffer();
		strVideoEncoders.ReleaseBuffer();
		strAudioEncoders.ReleaseBuffer();
	}

	return QCAP_RT_OK;
}



void CNetReceiverDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CNetReceiverDlg)

	//}}AFX_DATA_MAP

	DDX_Control(pDX, IDC_EDIT_CLIENT_PROFILE_INFO_URL, m_Edit_Video_Profile_Info_URL);
	DDX_Control(pDX, IDC_EDIT_CLIENT_PROFILE_INFO_VIDSRCNUM, m_Edit_Video_Profile_Info_SrcNum);
	DDX_Control(pDX, IDC_EDIT_CLIENT_PROFILE_INFO_AUDSRCNUM, m_Edit_Audio_Profile_Info_SrcNum);
	DDX_Control(pDX, IDC_EDIT_CLIENT_PROFILE_INFO_VIDENCNUM, m_Edit_Video_Profile_Info_EncNum);
	DDX_Control(pDX, IDC_EDIT_CLIENT_PROFILE_INFO_AUDENCNUM, m_Edit_Audio_Profile_Info_EncNum);

	DDX_Control(pDX, IDC_SLIDER_SET_CLIENT_VIDEO_PROFILE_PROPERTY_QUALITY, m_sldProfileProperty_quality);
	DDX_Control(pDX, IDC_SLIDER_SET_CLIENT_VIDEO_PROFILE_PROPERTY_BITRATE, m_sldProfileProperty_bitrate);
	DDX_Control(pDX, IDC_SLIDER_SET_CLIENT_VIDEO_PROFILE_PROPERTY_GOP, m_sldProfileProperty_gop);

	DDX_Text(pDX, IDC_STATIC_QUALITY_MAX, m_staticProfileProperty_quality_max);
	DDX_Text(pDX, IDC_STATIC_BITRATE_MAX, m_staticProfileProperty_bitrate_max);
	DDX_Text(pDX, IDC_STATIC_GOP_MAX, m_staticProfileProperty_gop_max);
	DDX_Control(pDX, IDC_EDIT_GET_CLIENT_VIDEO_PROFILE_PROPERTY_ENCODERFORMAT, m_Edit_Video_Profile_Property_Format);
	DDX_Control(pDX, IDC_EDIT_GET_CLIENT_VIDEO_PROFILE_PROPERTY_WIDTH, m_Edit_Video_Profile_Property_Width);
	DDX_Control(pDX, IDC_EDIT_GET_CLIENT_VIDEO_PROFILE_PROPERTY_HEIGHT, m_Edit_Video_Profile_Property_Height);

	DDX_Control(pDX, IDC_EDIT_GET_CLIENT_AUDIO_PROFILE_PROPERTY_ENCODERFORMAT, m_Edit_Audio_Profile_Property_EncoderFormat);
	DDX_Control(pDX, IDC_EDIT_GET_CLIENT_AUDIO_PROFILE_PROPERTY_CHANNELS, m_Edit_Audio_Profile_Property_Channel);
	DDX_Control(pDX, IDC_EDIT_GET_CLIENT_AUDIO_PROFILE_PROPERTY_BPS, m_Edit_Audio_Profile_Property_BPS);
	DDX_Control(pDX, IDC_EDIT_GET_CLIENT_AUDIO_PROFILE_PROPERTY_SF, m_Edit_Audio_Profile_Property_SF);

	DDX_Text(pDX, IDC_STATIC_AUDIO_BITRATE_MAX, m_staticProfileProperty_Audio_bitrate_max);
	DDX_Control(pDX, IDC_SLIDER_SET_CLIENT_AUDIO_PROFILE_PROPERTY_BITRATE, m_sldProfileProperty_Audio_bitrate);
	DDX_Control(pDX, IDC_EMULATOR_LIST, m_ListEmulator);
	DDX_Control(pDX, IDC_EMULATOR_PROFILE_LIST, m_ListProfiles);
	DDX_Control(pDX, IDC_EMULATOR_MANUFACTURER_LIST, m_ListManufacturer);
	DDX_Control(pDX, IDC_EMULATOR_VIDEO_SOURCE_LIST, m_ListVideoSources);
	DDX_Control(pDX, IDC_EMULATOR_AUDIO_SOURCE_LIST, m_ListAudioSources);
	DDX_Control(pDX, IDC_EMULATOR_VIDEO_ENCODER_LIST, m_ListVideoEncoders);
	DDX_Control(pDX, IDC_EMULATOR_AUDIO_ENCODER_LIST, m_ListAudioEncoders);
	DDX_Control(pDX, IDC_EMULATOR_MODEL_LIST, m_ListModel);
	DDX_Control(pDX, IDC_EMULATOR_FIRMARE_VERSION_LIST, m_ListFirmareVersion);
	DDX_Control(pDX, IDC_EMULATOR_SERIAL_NUMBER_LIST, m_ListServialNumer);
	DDX_Control(pDX, IDC_EMULATOR_HARDWARE_ID_LIST, m_ListHardwareID);
	DDX_Control(pDX, IDC_SLIDER_SET_CLIENT_VIDEO_PROFILE_PROPERTY_RECORD_MODE, m_sldProfileProperty_RecordMode);

	DDX_Text(pDX, IDC_STATIC_RECORD_MOD_MAX, m_staticProfileProperty_RecordMode_max);
	DDX_Control(pDX, IDC_SLIDER_SET_CLIENT_VIDEO_PROFILE_PROPERTY_FRAME_RATE, m_sldProfileProperty_FrameRate);

	DDX_Text(pDX, IDC_STATIC_FRAME_RATE_MAX, m_staticProfileProperty_FrameRate_max);
	DDX_Control(pDX, IDC_EDIT_CLIENT_CUSTOM_PROPERTY_SET, m_Edit_Client_Custom_Property_Set);
	DDX_Control(pDX, IDC_EDIT_CLIENT_CUSTOM_VALUE_SET, m_Edit_Client_Custom_Value_Set);

	DDX_Control(pDX, IDC_EDIT_CLIENT_CUSTOM_PROPERTY_GET, m_Edit_Client_Custom_Property_get);
	DDX_Control(pDX, IDC_EDIT_CLIENT_CUSTOM_VALUE_GET, m_Edit_Client_Custom_Value_get);
}

BEGIN_MESSAGE_MAP(CNetReceiverDlg, CDialog)
	//{{AFX_MSG_MAP(CNetReceiverDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_DESTROY()
	ON_WM_TIMER()

	//}}AFX_MSG_MAP

	ON_BN_CLICKED(IDC_BUTTON_COMMUNICATION_EMULATOR_START, &CNetReceiverDlg::OnBnClickedButtonCommunicationEmulatorStart)
	ON_BN_CLICKED(IDC_BUTTON_SET_CLIENT_CUSTOM_PROPERTY, &CNetReceiverDlg::OnBnClickedButtonSetClientCustomProperty)
	ON_BN_CLICKED(IDC_BUTTON_GET_CLIENT_CUSTOM_PROPERTY, &CNetReceiverDlg::OnBnClickedButtonGetClientCustomProperty)
	
	ON_LBN_DBLCLK(IDC_EMULATOR_LIST, &CNetReceiverDlg::OnLbnDblclkEmulatorList)
	ON_LBN_DBLCLK(IDC_EMULATOR_PROFILE_LIST, &CNetReceiverDlg::OnDblclkEmulatorProfileList)
	ON_NOTIFY(NM_OUTOFMEMORY, IDC_SLIDER_SET_CLIENT_VIDEO_PROFILE_PROPERTY_QUALITY, &CNetReceiverDlg::OnOutofmemorySliderSetClientVideoProfilePropertyQuality)
	ON_NOTIFY(NM_RELEASEDCAPTURE, IDC_SLIDER_SET_CLIENT_VIDEO_PROFILE_PROPERTY_QUALITY, &CNetReceiverDlg::OnReleasedcaptureSliderSetClientVideoProfilePropertyQuality)
	ON_NOTIFY(NM_OUTOFMEMORY, IDC_SLIDER_SET_CLIENT_VIDEO_PROFILE_PROPERTY_GOP, &CNetReceiverDlg::OnOutofmemorySliderSetClientVideoProfilePropertyGop)
	ON_NOTIFY(NM_RELEASEDCAPTURE, IDC_SLIDER_SET_CLIENT_VIDEO_PROFILE_PROPERTY_GOP, &CNetReceiverDlg::OnReleasedcaptureSliderSetClientVideoProfilePropertyGop)
	ON_NOTIFY(NM_OUTOFMEMORY, IDC_SLIDER_SET_CLIENT_VIDEO_PROFILE_PROPERTY_BITRATE, &CNetReceiverDlg::OnOutofmemorySliderSetClientVideoProfilePropertyBitrate)
	ON_NOTIFY(NM_RELEASEDCAPTURE, IDC_SLIDER_SET_CLIENT_VIDEO_PROFILE_PROPERTY_BITRATE, &CNetReceiverDlg::OnReleasedcaptureSliderSetClientVideoProfilePropertyBitrate)
	ON_NOTIFY(NM_OUTOFMEMORY, IDC_SLIDER_SET_CLIENT_AUDIO_PROFILE_PROPERTY_BITRATE, &CNetReceiverDlg::OnOutofmemorySliderSetClientAudioProfilePropertyBitrate)
	ON_NOTIFY(NM_RELEASEDCAPTURE, IDC_SLIDER_SET_CLIENT_AUDIO_PROFILE_PROPERTY_BITRATE, &CNetReceiverDlg::OnReleasedcaptureSliderSetClientAudioProfilePropertyBitrate)
	ON_NOTIFY(NM_OUTOFMEMORY, IDC_SLIDER_SET_CLIENT_VIDEO_PROFILE_PROPERTY_FRAME_RATE, &CNetReceiverDlg::OnOutofmemorySliderSetClientVideoProfilePropertyFrameRate)
	ON_NOTIFY(NM_RELEASEDCAPTURE, IDC_SLIDER_SET_CLIENT_VIDEO_PROFILE_PROPERTY_FRAME_RATE, &CNetReceiverDlg::OnReleasedcaptureSliderSetClientVideoProfilePropertyFrameRate)
	ON_NOTIFY(NM_OUTOFMEMORY, IDC_SLIDER_SET_CLIENT_VIDEO_PROFILE_PROPERTY_RECORD_MODE, &CNetReceiverDlg::OnOutofmemorySliderSetClientVideoProfilePropertyRecordMode)
	ON_NOTIFY(NM_RELEASEDCAPTURE, IDC_SLIDER_SET_CLIENT_VIDEO_PROFILE_PROPERTY_RECORD_MODE, &CNetReceiverDlg::OnReleasedcaptureSliderSetClientVideoProfilePropertyRecordMode)
	ON_BN_CLICKED(IDC_BUTTON_PROPFILE_PROPERTY_UPDATE, &CNetReceiverDlg::OnBnClickedButtonPropfilePropertyUpdate)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////


BOOL CNetReceiverDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here

	// INITIALIZE COM LIBRARY
	//
	HRESULT hr = CoInitialize( NULL );

	// INITIALIZE MEMBER VARIABLES
	//
	m_pEmulator = NULL;

	m_pCommuncationClient = NULL;

	strNetworkIP = "";

	strNetworkPort = "";

	strURL = "";

	strVidSrcNum = "";

	strAudSrcNum = "";

	strVidEncNum = "";

	strAudEncNum = "";

	m_nVideoSourceWidth = 0;

	m_nVideoSourceHeight = 0;

	m_nVideoSourceFrameRate = 0;

	m_nAudioSourceChannels = 0;

	m_nAudioSourceBitsPerSample = 0;

	m_nAudioSourceSampleFrequency = 0;

	m_nVidSrcNum = 0;

	m_nAudSrcNum = 0;

	m_nVidEncNum = 0;

	m_nAudEncNum = 0;

	m_pTotalVidEncOptions = 0;

	m_pVidEncOptionNum_Default = 0;

	m_pTotalAudEncOptions = 0;

	m_pAudEncOptionNum_Default = 0;

	m_nVideoEncoderEncoderFormat = 0;

	m_pWidthList = 0;

	m_pWidthListSize = 0;

	m_pWidth_Default = 0;

	m_pHeightList = 0;

	m_pHeightListSize = 0;

	m_pHeight_Default = 0;

	m_nVideoEncoderFrameRate_Min = 0;

	m_nVideoEncoderFrameRate_Max = 0;

	m_nVideoEncoderFrameRate_Default = 0;

	m_nVideoEncoderRecordMode_Min = 0;

	m_nVideoEncoderRecordMode_Max = 0;

	m_nVideoEncoderRecordMode_Default = 0;

	m_nVideoEncoderQuality_Min = 0;

	m_nVideoEncoderQuality_Max = 0;

	m_nVideoEncoderQuality_Default = 0;

	m_nVideoEncoderBitRate_Min = 0;

	m_nVideoEncoderBitRate_Max = 0;

	m_nVideoEncoderBitRate_Default = 0; 

	m_nVideoEncoderGOP_Min = 0;

	m_nVideoEncoderGOP_Max = 0;

	m_nVideoEncoderGOP_Default = 0;

	m_nAudioEncoderEncoderFormat = 0;

	m_pChannelsList = 0;

	m_pChannelsListSize = 0;

	m_pChannels_Default = 0;

	m_pBitsPerSampleList = 0;

	m_pBitsPerSampleListSize = 0;

	m_pBitsPerSample_Default = 0;

	m_pSampleFrequencyList = 0;

	m_pSampleFrequencyListSize = 0;

	m_pSampleFrequency_Default = 0;

	m_nAudioEncoderBitRate_Min = 0;

	m_nAudioEncoderBitRate_Max = 0;

	m_nAudioEncoderBitRate_Default = 0;

	m_Edit_Client_Custom_Property_Set.SetWindowText( "123" );

	m_Edit_Client_Custom_Value_Set.SetWindowText( "456" );

	m_Edit_Client_Custom_Property_get.SetWindowText( "789" );

	//

	ppszNetworkURL = 0;

	SetTimer( 0x00000000, 1000, NULL );

	InitializeCriticalSection( &m_hNetworkServerAccessCriticalSection );
	
	m_nPortArray = new ULONG[ 1024 ];

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CNetReceiverDlg::OnDestroy() 
{
	CDialog::OnDestroy();
	
	// TODO: Add your message handler code here

	//2015.01.12
	//
	if ( m_pEmulator != NULL ) {

		QCAP_STOP_COMMUNICATION_EMULATOR( m_pEmulator );

		QCAP_DESTROY_COMMUNICATION_EMULATOR( m_pEmulator );

		m_pEmulator = NULL;

	}

	if ( m_pCommuncationClient != NULL )
	{
		QCAP_STOP_COMMUNICATION_CLIENT( m_pCommuncationClient );

		QCAP_DESTROY_COMMUNICATION_CLIENT( m_pCommuncationClient );

		m_pCommuncationClient = NULL;
	}

	// UNINITIALIZE USER INTERFACE
	//
	KillTimer( 0x00000000 );

	UpdateData( TRUE );

	DeleteCriticalSection( &m_hNetworkServerAccessCriticalSection );

	if (m_nPortArray)
			delete []m_nPortArray;

	// UNINITIALIZE COM LIBRARY
	//
	CoUninitialize();
}

void CNetReceiverDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CNetReceiverDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CNetReceiverDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}


void CNetReceiverDlg::OnOK() 
{
	// TODO: Add extra validation here

//	CDialog::OnOK();
}


void CNetReceiverDlg::OnCancel() 
{
	// TODO: Add extra cleanup here

	CDialog::OnCancel();
}


void CNetReceiverDlg::OnTimer(UINT nIDEvent) 
{
	// TODO: Add your message handler code here and/or call default

	CDialog::OnTimer(nIDEvent);
}


void CNetReceiverDlg::OnBnClickedButtonCommunicationEmulatorStart()
{
	// TODO: Add your control notification handler code here

	if ( m_pEmulator != NULL ) {

		m_Edit_Video_Profile_Info_URL.SetWindowText( "" );

		m_Edit_Video_Profile_Info_SrcNum.SetWindowText( "" );

		m_Edit_Audio_Profile_Info_SrcNum.SetWindowText( "" );

		m_Edit_Video_Profile_Info_EncNum.SetWindowText( "" );

		m_Edit_Audio_Profile_Info_EncNum.SetWindowText( "" );

		m_Edit_Video_Profile_Property_Format.SetWindowText( "" );

		m_Edit_Video_Profile_Property_Width.SetWindowText( "" );

		m_Edit_Video_Profile_Property_Height.SetWindowText( "" );

		m_Edit_Audio_Profile_Property_EncoderFormat.SetWindowText( "" );

		m_Edit_Audio_Profile_Property_Channel.SetWindowText( "" );

		m_Edit_Audio_Profile_Property_BPS.SetWindowText( "" );

		m_Edit_Audio_Profile_Property_SF.SetWindowText( "" );

		m_sldProfileProperty_FrameRate.SetPos( 0 );

		m_sldProfileProperty_RecordMode.SetPos( 0 );

		m_sldProfileProperty_quality.SetPos( 0 );

		m_sldProfileProperty_bitrate.SetPos( 0 );

		m_sldProfileProperty_gop.SetPos( 0 );

		m_staticProfileProperty_FrameRate_max = "";

		m_staticProfileProperty_RecordMode_max = "";

		m_staticProfileProperty_quality_max = "";

		m_staticProfileProperty_bitrate_max = "";

		m_staticProfileProperty_gop_max = "";

		m_sldProfileProperty_Audio_bitrate.SetPos( 0 );

		m_staticProfileProperty_Audio_bitrate_max = "";

		m_Edit_Client_Custom_Property_Set.SetWindowText( "123" );

		m_Edit_Client_Custom_Value_Set.SetWindowText( "456" );

		m_Edit_Client_Custom_Property_get.SetWindowText( "789" );

		m_Edit_Client_Custom_Value_get.SetWindowText( "" );

		int count1 =  m_ListManufacturer.GetCount();

		for ( int i = 0; i < count1; i++ ) {
		
			m_ListManufacturer.DeleteString( 0 );

			m_ListModel.DeleteString( 0 );

			m_ListFirmareVersion.DeleteString( 0 );

			m_ListServialNumer.DeleteString( 0 );

			m_ListHardwareID.DeleteString( 0 );

			m_ListVideoSources.DeleteString( 0 );

			m_ListAudioSources.DeleteString( 0 );

			m_ListVideoEncoders.DeleteString( 0 );

			m_ListAudioEncoders.DeleteString( 0 );
		}

		int count2 =  m_ListProfiles.GetCount();

		for ( int i = 0; i < count2; i++ ) {
		
			m_ListProfiles.DeleteString( 0 );
		}

		int count3 =  m_ListEmulator.GetCount();

		for ( int i = 0; i < count3; i++ ) {
		
			m_ListEmulator.DeleteString( 0 );
		}

		QCAP_STOP_COMMUNICATION_EMULATOR( m_pEmulator );

		QCAP_DESTROY_COMMUNICATION_EMULATOR( m_pEmulator );

		m_pEmulator = NULL;

	}

	QCAP_CREATE_COMMUNICATION_ONVIF_EMULATOR( &m_pEmulator );

	QCAP_REGISTER_COMMUNICATION_EMULATOR_SCAN_DONE_CALLBACK( m_pEmulator, on_emulator_scan_done_callback, this );

	QCAP_START_COMMUNICATION_EMULATOR( m_pEmulator );

	UpdateData( FALSE );
}


void CNetReceiverDlg::OnBnClickedButtonGetClientCustomProperty()
{
	// TODO: Add your control notification handler code here

	CHAR	*	m_cValue = NULL;

	CString strCustomPropertyGet, m_strCustomValueGet;

	m_Edit_Client_Custom_Property_get.GetWindowText( strCustomPropertyGet );

	ULONG nPropertyGet = strCustomPropertyGet.GetLength();

	CHAR* pszPropertyGet = strCustomPropertyGet.GetBuffer( nPropertyGet+1 );

	if ( m_pCommuncationClient ) {

		QCAP_GET_COMMUNICATION_CLIENT_CUSTOM_PROPERTY( m_pCommuncationClient, pszPropertyGet, &m_cValue );

		SC_DEBUG( "on onvif client get custom property------------------> %s, %s", pszPropertyGet, m_cValue );
	
		m_strCustomValueGet.Format( "%s", m_cValue );

		m_Edit_Client_Custom_Value_get.SetWindowText( m_strCustomValueGet );

	}
}


void CNetReceiverDlg::OnBnClickedButtonSetClientCustomProperty()
{
	// TODO: Add your control notification handler code here

	if ( m_pCommuncationClient ) {

		CString  strProperty, strValue;

		m_Edit_Client_Custom_Property_Set.GetWindowText( strProperty );

		m_Edit_Client_Custom_Value_Set.GetWindowText( strValue );

		ULONG nProperty = strProperty.GetLength();

		ULONG nValue = strValue.GetLength();

		CHAR* pszProperty = strProperty.GetBuffer( nProperty+1 );

		CHAR* pszValue = strValue.GetBuffer( nValue+1 );

		QCAP_SET_COMMUNICATION_CLIENT_CUSTOM_PROPERTY( m_pCommuncationClient, pszProperty, pszValue );

		SC_DEBUG( "on onvif client set custom property------------------> %s, %s", pszProperty, pszValue );

		strProperty.ReleaseBuffer();

		strValue.ReleaseBuffer();
	}
}


void CNetReceiverDlg::OnLbnDblclkEmulatorList()
{	
	if ( m_pEmulator ) {

		//strcpy(m_szBuf, m_strIP[m_ListEmulator.GetCurSel()].GetString());

		int row = m_ListEmulator.GetCurSel();

		CString srtingNetworkURL;

		m_ListEmulator.GetText(row, srtingNetworkURL);

		ULONG nStrlen = srtingNetworkURL.GetLength();

		CHAR* psz = srtingNetworkURL.GetBuffer( nStrlen+1 );

		QCAP_CREATE_COMMUNICATION_ONVIF_CLIENT( psz, &m_pCommuncationClient );

		QCAP_REGISTER_COMMUNICATION_CLIENT_CONNECTED_CALLBACK( m_pCommuncationClient, on_communication_client_connected_callback, this );

		QRESULT QR;

		QR = QCAP_START_COMMUNICATION_CLIENT( m_pCommuncationClient );

	}
}


void CNetReceiverDlg::OnDblclkEmulatorProfileList()
{
	// TODO: Add your control notification handler code here

	if ( m_pCommuncationClient ) {

		// Onvif Client Profile Info
		//
		QCAP_GET_COMMUNICATION_CLIENT_PROFILE_INFO( m_pCommuncationClient, m_ListProfiles.GetCurSel(), &m_ppURL, &m_nVidSrcNum, &m_nAudSrcNum, &m_nVidEncNum, &m_nAudEncNum );
	
		SC_DEBUG("-----------m_ppURL : %s, m_nVidSrcNum :%d, m_nAudSrcNum :%d, m_nVidEncNum :%d, m_nAudEncNum :%d", m_ppURL, m_nVidSrcNum, m_nAudSrcNum, m_nVidEncNum, m_nAudEncNum);

		strURL = (char*)m_ppURL;

		strVidSrcNum.Format( "%1d", m_nVidSrcNum );

		strAudSrcNum.Format( "%1d", m_nAudSrcNum );

		strVidEncNum.Format( "%1d", m_nVidEncNum );

		strAudEncNum.Format( "%1d", m_nAudEncNum );

		m_Edit_Video_Profile_Info_URL.SetWindowText( strURL );

		m_Edit_Video_Profile_Info_SrcNum.SetWindowText( strVidSrcNum );

		m_Edit_Audio_Profile_Info_SrcNum.SetWindowText( strAudSrcNum );

		m_Edit_Video_Profile_Info_EncNum.SetWindowText( strVidEncNum );

		m_Edit_Audio_Profile_Info_EncNum.SetWindowText( strAudEncNum );

		// Onvif Client Encoder Info
		//
		QCAP_GET_COMMUNICATION_CLIENT_VIDEO_ENCODER_INFO( m_pCommuncationClient, m_ListProfiles.GetCurSel(), &m_pTotalVidEncOptions, &m_pVidEncOptionNum_Default );

		SC_DEBUG("-------------m_pTotalVidEncOptions = %d, m_pVidEncOptionNum_Default = %d", m_pTotalVidEncOptions, m_pVidEncOptionNum_Default);

		QCAP_GET_COMMUNICATION_CLIENT_AUDIO_ENCODER_INFO( m_pCommuncationClient, m_ListProfiles.GetCurSel(), &m_pTotalAudEncOptions, &m_pAudEncOptionNum_Default );

		SC_DEBUG("-------------m_pTotalAudEncOptions = %d, m_pAudEncOptionNum_Default = %d", m_pTotalAudEncOptions, m_pAudEncOptionNum_Default);
		
		QCAP_GET_COMMUNICATION_CLIENT_PROFILE_VIDEO_PROPERTY( m_pCommuncationClient, m_ListProfiles.GetCurSel(), &m_nVideoProfileEncoderFormat, &m_nVideoProfileWidth, &m_nVideoProfileHeight, &m_nVideoEProfileFrameRate, &m_nVideoEProfileRecordMode, &m_nVideoEProfileQuality, &m_nVideoEProfileBitRate, &m_nVideoEProfileGOP );
		
		QCAP_GET_COMMUNICATION_CLIENT_PROFILE_AUDIO_PROPERTY( m_pCommuncationClient, m_ListProfiles.GetCurSel(), &m_nAudioProfileEncoderFormat, &m_nAudioProfileChannels, &m_nAudioProfileBitsPerSample, &m_nAudioProfileSampleFrequency, &m_nAudioProfileBitRate );

		QCAP_GET_COMMUNICATION_CLIENT_VIDEO_ENCODER_OPTION_INFO( m_pCommuncationClient, m_ListProfiles.GetCurSel(), m_pVidEncOptionNum_Default, &m_nVideoEncoderEncoderFormat, &m_pWidthList, &m_pWidthListSize, &m_pWidth_Default
			
			, &m_pHeightList, &m_pHeightListSize, &m_pHeight_Default, &m_nVideoEncoderFrameRate_Min, &m_nVideoEncoderFrameRate_Max, &m_nVideoEncoderFrameRate_Default, &m_nVideoEncoderRecordMode_Min, &m_nVideoEncoderRecordMode_Max, &m_nVideoEncoderRecordMode_Default, &m_nVideoEncoderQuality_Min, &m_nVideoEncoderQuality_Max, &m_nVideoEncoderQuality_Default, &m_nVideoEncoderBitRate_Min, &m_nVideoEncoderBitRate_Max, &m_nVideoEncoderBitRate_Default, &m_nVideoEncoderGOP_Min, &m_nVideoEncoderGOP_Max, &m_nVideoEncoderGOP_Default);

		SC_DEBUG("-------m_pWidthList :%d, m_pWidthListSize :%d, m_pWidth_Default :%d, m_pHeightList :%d, m_pHeightListSize :%d, m_pHeight_Default :%d", m_pWidthList, m_pWidthListSize, m_pWidth_Default, m_pHeightList, m_pHeightListSize, m_pHeight_Default);

		SC_DEBUG("-------m_nVideoEncoderFrameRate_Min :%d, m_nVideoEncoderFrameRate_Max :%d, m_nVideoEncoderFrameRate_Default :%d, m_nVideoEncoderRecordMode_Min :%d, m_nVideoEncoderRecordMode_Max :%d, m_nVideoEncoderRecordMode_Default :%d", m_nVideoEncoderFrameRate_Min, m_nVideoEncoderFrameRate_Max, m_nVideoEncoderFrameRate_Default, m_nVideoEncoderRecordMode_Min, m_nVideoEncoderRecordMode_Max, m_nVideoEncoderRecordMode_Default);

		SC_DEBUG("-------m_nVideoEncoderQuality_Min :%d, m_nVideoEncoderQuality_Max :%d, m_nVideoEncoderQuality_Default :%d, m_nVideoEncoderBitRate_Min :%d, m_nVideoEncoderBitRate_Max :%d, m_nVideoEncoderBitRate_Default :%d", m_nVideoEncoderQuality_Min, m_nVideoEncoderQuality_Max, m_nVideoEncoderQuality_Default, m_nVideoEncoderBitRate_Min, m_nVideoEncoderBitRate_Max, m_nVideoEncoderBitRate_Default);

		SC_DEBUG("-------m_nVideoEncoderGOP_Min :%d, m_nVideoEncoderGOP_Max :%d, m_nVideoEncoderGOP_Default :%d", m_nVideoEncoderGOP_Min, m_nVideoEncoderGOP_Max, m_nVideoEncoderGOP_Default);

		QCAP_GET_COMMUNICATION_CLIENT_AUDIO_ENCODER_OPTION_INFO( m_pCommuncationClient, m_ListProfiles.GetCurSel(), m_pAudEncOptionNum_Default, &m_nAudioEncoderEncoderFormat, &m_pChannelsList, &m_pChannelsListSize, &m_pChannels_Default, &m_pBitsPerSampleList, &m_pBitsPerSampleListSize
			
			, &m_pBitsPerSample_Default, &m_pSampleFrequencyList, &m_pSampleFrequencyListSize, &m_pSampleFrequency_Default, &m_nAudioEncoderBitRate_Min, &m_nAudioEncoderBitRate_Max, &m_nAudioEncoderBitRate_Default);

		SC_DEBUG("-------m_pChannelsList :%d, m_pChannelsListSize :%d, m_pChannels_Default :%d", m_pChannelsList, m_pChannelsListSize, m_pChannels_Default);

		SC_DEBUG("-------m_pBitsPerSampleList :%d, m_pBitsPerSampleListSize :%d, m_pBitsPerSample_Default :%d", m_pBitsPerSampleList, m_pBitsPerSampleListSize, m_pBitsPerSample_Default);

		SC_DEBUG("-------m_pSampleFrequencyList :%d, m_pSampleFrequencyListSize :%d, m_pSampleFrequency_Default :%d", m_pSampleFrequencyList, m_pSampleFrequencyListSize, m_pSampleFrequency_Default);

		SC_DEBUG("-------m_nAudioEncoderBitRate_Min :%d, m_nAudioEncoderBitRate_Max :%d, m_nAudioEncoderBitRate_Default :%d", m_nAudioEncoderBitRate_Min, m_nAudioEncoderBitRate_Max, m_nAudioEncoderBitRate_Default);

		//Client ProFile Property
		//
		strVideoProfileEncoderFormat.Format( "%1d", m_nVideoProfileEncoderFormat );

		strVideoProfileWidth.Format( "%1d", m_nVideoProfileWidth );

		strVideoProfileHeight.Format( "%1d", m_nVideoProfileHeight );

		strAudioProfileEncoderFormat.Format( "%1d", m_nAudioProfileEncoderFormat );

		strAudioProfileChannels.Format( "%1d", m_nAudioProfileChannels );

		strAudioProfileBitsPerSample.Format( "%1d", m_nAudioProfileBitsPerSample );

		strAudioProfileSampleFrequency.Format( "%1d", m_nAudioProfileSampleFrequency );

		m_Edit_Video_Profile_Property_Format.SetWindowText( strVideoProfileEncoderFormat );

		m_Edit_Video_Profile_Property_Width.SetWindowText( strVideoProfileWidth );

		m_Edit_Video_Profile_Property_Height.SetWindowText( strVideoProfileHeight );

		m_Edit_Audio_Profile_Property_EncoderFormat.SetWindowText( strAudioProfileEncoderFormat );

		m_Edit_Audio_Profile_Property_Channel.SetWindowText( strAudioProfileChannels );

		m_Edit_Audio_Profile_Property_BPS.SetWindowText( strAudioProfileBitsPerSample );

		m_Edit_Audio_Profile_Property_SF.SetWindowText( strAudioProfileSampleFrequency );

		//Set Client Video Profile Range
		//
		m_sldProfileProperty_FrameRate.SetRange( m_nVideoEncoderFrameRate_Min, m_nVideoEncoderFrameRate_Max, TRUE );

		m_sldProfileProperty_RecordMode.SetRange( m_nVideoEncoderRecordMode_Min, m_nVideoEncoderRecordMode_Max, TRUE );

		m_sldProfileProperty_quality.SetRange( m_nVideoEncoderQuality_Min, m_nVideoEncoderQuality_Max, TRUE );

		m_sldProfileProperty_bitrate.SetRange( m_nVideoEncoderBitRate_Min, m_nVideoEncoderBitRate_Max, TRUE );

		m_sldProfileProperty_gop.SetRange( m_nVideoEncoderGOP_Min, m_nVideoEncoderGOP_Max, TRUE );

		m_sldProfileProperty_FrameRate.SetPos( m_nVideoEProfileFrameRate );

		m_sldProfileProperty_RecordMode.SetPos( m_nVideoEProfileRecordMode );

		m_sldProfileProperty_quality.SetPos( m_nVideoEProfileQuality );

		m_sldProfileProperty_bitrate.SetPos( m_nVideoEProfileBitRate );

		m_sldProfileProperty_gop.SetPos( m_nVideoEProfileGOP );
		
		CHAR sz6_max[ MAX_PATH ] = { 0 };

		itoa( m_nVideoEProfileFrameRate, sz6_max, 10 );

		m_staticProfileProperty_FrameRate_max = (LPTSTR)sz6_max;

		CHAR sz7_max[ MAX_PATH ] = { 0 };

		itoa( m_nVideoEProfileRecordMode, sz7_max, 10 );

		m_staticProfileProperty_RecordMode_max = (LPTSTR)sz7_max;

		CHAR sz8_max[ MAX_PATH ] = { 0 };

		itoa( m_nVideoEProfileQuality, sz8_max, 10 );

		m_staticProfileProperty_quality_max = (LPTSTR)sz8_max;

		CHAR sz9_max[ MAX_PATH ] = { 0 };

		itoa( m_nVideoEProfileBitRate, sz9_max, 10 );

		m_staticProfileProperty_bitrate_max = (LPTSTR)sz9_max;

		CHAR sz10_max[ MAX_PATH ] = { 0 };

		itoa( m_nVideoEProfileGOP, sz10_max, 10 );

		m_staticProfileProperty_gop_max = (LPTSTR)sz10_max;

		// Set Client Audio Profile Range
		//
		m_sldProfileProperty_Audio_bitrate.SetRange( m_nAudioEncoderBitRate_Min, m_nAudioEncoderBitRate_Max, TRUE );

		m_sldProfileProperty_Audio_bitrate.SetPos( m_nAudioProfileBitRate );

		CHAR sz12_max[ MAX_PATH ] = { 0 };

		itoa( m_nAudioProfileBitRate, sz12_max, 10 );

		m_staticProfileProperty_Audio_bitrate_max = (LPTSTR)sz12_max;

		UpdateData( FALSE );

	}
}


void CNetReceiverDlg::OnOutofmemorySliderSetClientVideoProfilePropertyFrameRate(NMHDR *pNMHDR, LRESULT *pResult)
{
	// TODO: Add your control notification handler code here
	*pResult = 0;
}

void CNetReceiverDlg::OnOutofmemorySliderSetClientVideoProfilePropertyRecordMode(NMHDR *pNMHDR, LRESULT *pResult)
{
	// TODO: Add your control notification handler code here
	*pResult = 0;
}

void CNetReceiverDlg::OnOutofmemorySliderSetClientVideoProfilePropertyQuality(NMHDR *pNMHDR, LRESULT *pResult)
{
	// TODO: Add your control notification handler code here

	*pResult = 0;
}

void CNetReceiverDlg::OnOutofmemorySliderSetClientVideoProfilePropertyBitrate(NMHDR *pNMHDR, LRESULT *pResult)
{
	// TODO: Add your control notification handler code here

	*pResult = 0;
}

void CNetReceiverDlg::OnOutofmemorySliderSetClientVideoProfilePropertyGop(NMHDR *pNMHDR, LRESULT *pResult)
{
	// TODO: Add your control notification handler code here

	*pResult = 0;
}

void CNetReceiverDlg::OnOutofmemorySliderSetClientAudioProfilePropertyBitrate(NMHDR *pNMHDR, LRESULT *pResult)
{
	// TODO: Add your control notification handler code here

	*pResult = 0;
}

void CNetReceiverDlg::OnReleasedcaptureSliderSetClientVideoProfilePropertyFrameRate(NMHDR *pNMHDR, LRESULT *pResult)
{
	// TODO: Add your control notification handler code here

	CHAR sz1[ MAX_PATH ] = { 0 };

	itoa( m_sldProfileProperty_FrameRate.GetPos(), sz1, 10 );

	m_staticProfileProperty_FrameRate_max = (LPTSTR)sz1;

	UpdateData( FALSE );

	*pResult = 0;
}

void CNetReceiverDlg::OnReleasedcaptureSliderSetClientVideoProfilePropertyRecordMode(NMHDR *pNMHDR, LRESULT *pResult)
{
	// TODO: Add your control notification handler code here

	CHAR sz2[ MAX_PATH ] = { 0 };

	itoa( m_sldProfileProperty_RecordMode.GetPos(), sz2, 10 );

	m_staticProfileProperty_RecordMode_max = (LPTSTR)sz2;

	UpdateData( FALSE );

	*pResult = 0;
}

void CNetReceiverDlg::OnReleasedcaptureSliderSetClientVideoProfilePropertyQuality(NMHDR *pNMHDR, LRESULT *pResult)
{
	// TODO: Add your control notification handler code here

	CHAR sz3[ MAX_PATH ] = { 0 };

	itoa( m_sldProfileProperty_quality.GetPos(), sz3, 10 );

	m_staticProfileProperty_quality_max = (LPTSTR)sz3;

	UpdateData( FALSE );

	*pResult = 0;
}

void CNetReceiverDlg::OnReleasedcaptureSliderSetClientVideoProfilePropertyBitrate(NMHDR *pNMHDR, LRESULT *pResult)
{
	// TODO: Add your control notification handler code here

	CHAR sz4[ MAX_PATH ] = { 0 };

	itoa( m_sldProfileProperty_bitrate.GetPos(), sz4, 10 );

	m_staticProfileProperty_bitrate_max = (LPTSTR)sz4;

	UpdateData( FALSE );

	*pResult = 0;
}

void CNetReceiverDlg::OnReleasedcaptureSliderSetClientVideoProfilePropertyGop(NMHDR *pNMHDR, LRESULT *pResult)
{
	// TODO: Add your control notification handler code here
	
	CHAR sz5[ MAX_PATH ] = { 0 };

	itoa( m_sldProfileProperty_gop.GetPos(), sz5, 10 );

	m_staticProfileProperty_gop_max = (LPTSTR)sz5;

	UpdateData( FALSE );

	*pResult = 0;
}

void CNetReceiverDlg::OnReleasedcaptureSliderSetClientAudioProfilePropertyBitrate(NMHDR *pNMHDR, LRESULT *pResult)
{
	// TODO: Add your control notification handler code here

	CHAR sz6[ MAX_PATH ] = { 0 };

	itoa( m_sldProfileProperty_Audio_bitrate.GetPos(), sz6, 10 );

	m_staticProfileProperty_Audio_bitrate_max = (LPTSTR)sz6;

	UpdateData( FALSE );

	*pResult = 0;
}

void CNetReceiverDlg::OnBnClickedButtonPropfilePropertyUpdate()
{
	// TODO: Add your control notification handler code here

	if ( m_pCommuncationClient ) {

		// Set Profile Property
		//
		m_Edit_Video_Profile_Property_Format.GetWindowTextA( strVideoProfileEncoderFormat );
		ULONG nVideoProfileEncoderFormat = atof( strVideoProfileEncoderFormat );

		m_Edit_Video_Profile_Property_Width.GetWindowTextA( strVideoProfileWidth );
		ULONG nVideoProfileWidth = atof( strVideoProfileWidth );

		m_Edit_Video_Profile_Property_Height.GetWindowTextA( strVideoProfileHeight );
		ULONG nVideoProfileHeight = atof( strVideoProfileHeight );

		ULONG nVideoProfileFrameRate = m_sldProfileProperty_FrameRate.GetPos();

		ULONG nVideoProfileRecordMode = m_sldProfileProperty_RecordMode.GetPos();

		ULONG nVideoProfilequality = m_sldProfileProperty_quality.GetPos();

		ULONG nVideoProfilebitrate = m_sldProfileProperty_bitrate.GetPos();

		ULONG nVideoProfilegop = m_sldProfileProperty_gop.GetPos();

		m_Edit_Audio_Profile_Property_EncoderFormat.GetWindowTextA( strAudioProfileEncoderFormat );
		ULONG nAudioProfileEncoderFormat = atof( strAudioProfileEncoderFormat );

		m_Edit_Audio_Profile_Property_Channel.GetWindowTextA( strAudioProfileChannels );
		ULONG nAudioProfileChannel = atof( strAudioProfileChannels );

		m_Edit_Audio_Profile_Property_BPS.GetWindowTextA( strAudioProfileBitsPerSample );
		ULONG nAudioProfileBitsPerSample = atof( strAudioProfileBitsPerSample );

		m_Edit_Audio_Profile_Property_SF.GetWindowTextA( strAudioProfileSampleFrequency );
		ULONG nAudioProfileSampleFrequency = atof( strAudioProfileSampleFrequency );

		ULONG nAudiooProfileBitRate = m_sldProfileProperty_Audio_bitrate.GetPos();

		QCAP_SET_COMMUNICATION_CLIENT_PROFILE_VIDEO_PROPERTY( m_pCommuncationClient, m_ListProfiles.GetCurSel(), nVideoProfileEncoderFormat, nVideoProfileWidth, nVideoProfileHeight, nVideoProfileFrameRate, nVideoProfileRecordMode, nVideoProfilequality, nVideoProfilebitrate, nVideoProfilegop );
		
		QCAP_SET_COMMUNICATION_CLIENT_PROFILE_AUDIO_PROPERTY( m_pCommuncationClient, m_ListProfiles.GetCurSel(), nAudioProfileEncoderFormat, nAudioProfileChannel, nAudioProfileBitsPerSample, nAudioProfileSampleFrequency, nAudiooProfileBitRate );


		// Get Profile Property
		//
		QCAP_GET_COMMUNICATION_CLIENT_PROFILE_VIDEO_PROPERTY( m_pCommuncationClient, m_ListProfiles.GetCurSel(), &m_nVideoProfileEncoderFormat, &m_nVideoProfileWidth, &m_nVideoProfileHeight, &m_nVideoEProfileFrameRate, &m_nVideoEProfileRecordMode, &m_nVideoEProfileQuality, &m_nVideoEProfileBitRate, &m_nVideoEProfileGOP );
		QCAP_GET_COMMUNICATION_CLIENT_PROFILE_AUDIO_PROPERTY( m_pCommuncationClient, m_ListProfiles.GetCurSel(), &m_nAudioProfileEncoderFormat, &m_nAudioProfileChannels, &m_nAudioProfileBitsPerSample, &m_nAudioProfileSampleFrequency, &m_nAudioProfileBitRate );

		strVideoProfileEncoderFormat.Format( "%1d", m_nVideoProfileEncoderFormat );

		strVideoProfileWidth.Format( "%1d", m_nVideoProfileWidth );

		strVideoProfileHeight.Format( "%1d", m_nVideoProfileHeight );

		strAudioProfileEncoderFormat.Format( "%1d", m_nAudioProfileEncoderFormat );

		strAudioProfileChannels.Format( "%1d", m_nAudioProfileChannels );

		strAudioProfileBitsPerSample.Format( "%1d", m_nAudioProfileBitsPerSample );

		strAudioProfileSampleFrequency.Format( "%1d", m_nAudioProfileSampleFrequency );

		m_Edit_Video_Profile_Property_Format.SetWindowText( strVideoProfileEncoderFormat );

		m_Edit_Video_Profile_Property_Width.SetWindowText( strVideoProfileWidth );

		m_Edit_Video_Profile_Property_Height.SetWindowText( strVideoProfileHeight );

		m_Edit_Audio_Profile_Property_EncoderFormat.SetWindowText( strAudioProfileEncoderFormat );

		m_Edit_Audio_Profile_Property_Channel.SetWindowText( strAudioProfileChannels );

		m_Edit_Audio_Profile_Property_BPS.SetWindowText( strAudioProfileBitsPerSample );

		m_Edit_Audio_Profile_Property_SF.SetWindowText( strAudioProfileSampleFrequency );


	}
}
